<?php
$slug = tenant_slug();
$rows = $rows ?? [];
$type = $type ?? 'quote';
?>

<div class="flex flex-wrap items-center justify-between gap-2">
  <div>
    <h2 class="text-lg font-semibold">Teklifler</h2>
    <p class="mt-1 text-sm text-slate-500 dark:text-slate-400">Oluşturduğun teklifleri buradan yönetebilirsin.</p>
  </div>
  <div class="flex flex-wrap gap-2">
    <a href="<?= e(base_path('/'.$slug.'/create')) ?>"
       class="rounded-xl bg-slate-900 px-4 py-2 text-sm text-white dark:bg-white dark:text-slate-900">+ Teklif Oluştur</a>
  </div>
</div>

<?php if (!empty($ok)): ?><div class="mt-3 rounded-xl border border-emerald-200 bg-emerald-50 px-3 py-2 text-sm text-emerald-900 dark:border-emerald-900/40 dark:bg-emerald-950/30 dark:text-emerald-100"><?= e($ok) ?></div><?php endif; ?>
<?php if (!empty($err)): ?><div class="mt-3 rounded-xl border border-red-200 bg-red-50 px-3 py-2 text-sm text-red-900 dark:border-red-900/40 dark:bg-red-950/30 dark:text-red-emerald-100"><?= e($err) ?></div><?php endif; ?>

<div class="mt-4 overflow-auto rounded-2xl border border-slate-200 dark:border-slate-800">
  <table class="min-w-full text-sm">
    <thead class="text-left text-xs text-slate-500 dark:text-slate-400">
      <tr>
        <th class="px-4 py-3">Belge No</th>
        <th class="px-4 py-3">Müşteri</th>
        <th class="px-4 py-3">Tarih</th>
        <th class="px-4 py-3">Vade</th>
        <th class="px-4 py-3">Durum</th>
        <th class="px-4 py-3 text-right">Toplam</th>
        <th class="px-4 py-3 text-right">İşlemler</th>
      </tr>
    </thead>

    <tbody class="divide-y divide-slate-100 dark:divide-slate-800">
      <?php if (count($rows) === 0): ?>
        <tr><td colspan="7" class="px-4 py-6 text-center text-slate-500 dark:text-slate-400">Henüz teklif yok.</td></tr>
      <?php endif; ?>

      <?php foreach ($rows as $r): ?>
        <?php
          $id = (int)$r['id'];
          $status = (string)($r['status'] ?? 'draft');
          $statusLabel = [
            'draft' => 'Taslak',
            'sent' => 'Gönderildi',
            'paid' => 'Ödendi',
            'overdue' => 'Gecikmiş',
          ][$status] ?? $status;

          $badge = match($status){
            'paid' => 'bg-emerald-50 text-emerald-800 border-emerald-200 dark:bg-emerald-950/30 dark:text-emerald-200 dark:border-emerald-900/40',
            'sent' => 'bg-blue-50 text-blue-800 border-blue-200 dark:bg-blue-950/30 dark:text-blue-emerald-200 dark:border-blue-900/40',
            'overdue' => 'bg-red-50 text-red-800 border-red-200 dark:bg-red-950/30 dark:text-red-200 dark:border-red-900/40',
            default => 'bg-slate-50 text-slate-700 border-slate-200 dark:bg-slate-950/30 dark:text-slate-200 dark:border-slate-800',
          };
        ?>
        <tr>
          <td class="px-4 py-3 font-medium"><?= e((string)$r['doc_no']) ?></td>
          <td class="px-4 py-3"><?= e((string)$r['customer_name']) ?></td>
          <td class="px-4 py-3"><?= e((string)$r['issue_date']) ?></td>
          <td class="px-4 py-3"><?= e((string)($r['due_date'] ?? '')) ?></td>
          <td class="px-4 py-3">
            <span class="rounded-full border px-2 py-0.5 text-xs <?= e($badge) ?>"><?= e($statusLabel) ?></span>
          </td>
          <td class="px-4 py-3 text-right font-semibold"><?= e((string)$r['currency_symbol']) ?> <?= number_format((float)$r['total'],2,',','.') ?></td>

          <td class="px-4 py-3 text-right">
            <div class="flex flex-wrap justify-end gap-2">
              <a href="<?= e(base_path('/'.$slug.'/quotes/view?id='.$id)) ?>" class="rounded-lg border border-slate-200 px-3 py-1.5 text-xs hover:bg-slate-50 dark:border-slate-800 dark:hover:bg-slate-900/50">Görüntüle</a>
              <a href="<?= e(base_path('/'.$slug.'/quotes/edit?id='.$id)) ?>" class="rounded-lg border border-slate-200 px-3 py-1.5 text-xs hover:bg-slate-50 dark:border-slate-800 dark:hover:bg-slate-900/50">Düzenle</a>
              <a target="_blank" href="<?= e(base_path('/'.$slug.'/quotes/print?id='.$id)) ?>" class="rounded-lg bg-slate-900 px-3 py-1.5 text-xs text-white dark:bg-white dark:text-slate-900">PDF</a>

              <form method="post" action="<?= e(base_path('/'.$slug.'/documents/action')) ?>" onsubmit="return confirm('Teklif çöp kutusuna taşınsın mı?')" class="inline">
                <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
                <input type="hidden" name="action" value="trash">
                <input type="hidden" name="type" value="quote">
                <input type="hidden" name="id" value="<?= (int)$id ?>">
                <button class="rounded-lg border border-red-200 px-3 py-1.5 text-xs text-red-700 hover:bg-red-50 dark:border-red-900/40 dark:text-red-200 dark:hover:bg-red-950/30">Çöpe At</button>
              </form>
            </div>
          </td>
        </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</div>
